<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 6) {
        throw new Exception("Parámetros incompletos. Se requieren 6 datos.");
    }

    // Asignar parámetros
    $cnombre      = $datos[0];
    $cabrev       = $datos[1];
    $cabrevuniv   = $datos[2];
    $cservicio    = filter_var($datos[3], FILTER_VALIDATE_BOOLEAN);
    $nidundmed    = intval($datos[4]);
    $cestado      = $datos[5];

    // Ejecutar función PostgreSQL que retorna solo el ID
    $sql = "SELECT im_undmedida(:cnombre, :cabrev, :cabrevuniv, :cservicio, :nidundmed, :cestado) AS id_undmed";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':cnombre', $cnombre, PDO::PARAM_STR);
    $stmt->bindValue(':cabrev', $cabrev, PDO::PARAM_STR);
    $stmt->bindValue(':cabrevuniv', $cabrevuniv, PDO::PARAM_STR);
    $stmt->bindValue(':cservicio', $cservicio, PDO::PARAM_BOOL);
    $stmt->bindValue(':nidundmed', $nidundmed, PDO::PARAM_INT);
    $stmt->bindValue(':cestado', $cestado, PDO::PARAM_STR);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $respuesta = [];

    if ($cestado === "NUEVO") {
        if ($result && isset($result['id_undmed']) && $result['id_undmed'] > 0) {
            $respuesta = [
                "ESTADO" => "1",
                "ID" => $result['id_undmed'],
                "MENSAJE" => "LA INFORMACIÓN SE GUARDÓ CORRECTAMENTE"
            ];
        } else {
            $respuesta = [
                "ESTADO" => "0",
                "ID" => "0",
                "MENSAJE" => "ERROR AL GUARDAR LA INFORMACIÓN"
            ];
        }
    } else { // MODIFICAR
        $respuesta = [
            "ESTADO" => "1",
            "ID" => strval($nidundmed),
            "MENSAJE" => "LA INFORMACIÓN SE ACTUALIZÓ CORRECTAMENTE"
        ];
    }

    echo json_encode($respuesta, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
