<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Incluir archivo de conexión PDO a PostgreSQL
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    // Leer el cuerpo de la solicitud
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validar los parámetros
    if (!is_array($datos) || count($datos) < 4) {
        throw new Exception("Parámetros inválidos. Se requieren 4 valores.");
    }

    // Preparar la llamada a la función (debes crear esta función en PostgreSQL si no existe)
    $sql = "CALL activa_dialogo(:menu_id, :submenu_id, :usuario_id, :activo)";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':menu_id', $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':submenu_id', $datos[1], PDO::PARAM_INT);
    $stmt->bindValue(':usuario_id', $datos[2], PDO::PARAM_INT);
    $stmt->bindValue(':activo', (bool)$datos[3], PDO::PARAM_BOOL);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($rows, JSON_UNESCAPED_UNICODE);
} catch (Exception $e) {
    error_response("Error: " . $e->getMessage());
} finally {
    $conn = null;
}

// Función para manejar errores JSON
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
