<?php
header('Content-Type: application/json');

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$data = json_decode(file_get_contents("php://input"), true);

try {
    $conn->beginTransaction(); // INICIA TRANSACCIÓN

    $jsonInput = json_encode($data);
    $stmt = $conn->prepare("SELECT im_producto(:json_input) AS resultado");
    $stmt->bindParam(':json_input', $jsonInput, PDO::PARAM_STR);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $jsonResult = json_decode($result['resultado'], true);

    if (!$jsonResult || $jsonResult['estado'] === '11') {
        $conn->rollBack(); // REVERSA SI FALLA
        error_log("⚠️ Error al guardar producto: " . ($jsonResult['mensaje'] ?? 'Sin mensaje'));
        http_response_code(500);
    } else {
        $conn->commit(); // CONFIRMA SI TODO OK
    }

    echo json_encode($jsonResult);
} catch (PDOException $e) {
    $conn->rollBack(); // Asegura rollback si hay excepción
    error_log("⚠️ Error de base de datos: " . $e->getMessage());
    echo json_encode([
        'estado' => '11',
        'mensaje' => 'Error en la conexión o ejecución: ' . $e->getMessage()
    ]);
} finally {
    $conn = null;
}
