<?php
error_reporting(E_ALL);
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

$usuarioId = TokenValidator::validar($conn);

try {
    $input = json_decode(file_get_contents("php://input"), true);

    $producto_id = $input['producto_id'] ?? null;
    $registros = $input['registros'] ?? [];

    if (!$producto_id || !is_array($registros)) {
        throw new Exception("Datos incompletos para grabar códigos externos.");
    }

    $sql = "SELECT * FROM im_productos_proveedor(:json, :producto_id)";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':json', json_encode($registros), PDO::PARAM_STR);
    $stmt->bindValue(':producto_id', $producto_id, PDO::PARAM_INT);
    $stmt->execute();

    echo json_encode(["ESTADO" => "1", "MENSAJE" => "Códigos guardados correctamente"]);
} catch (Exception $e) {
    echo json_encode(["ESTADO" => "0", "MENSAJE" => "Error: " . $e->getMessage()]);
}
