<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

$usuarioId = TokenValidator::validar($conn); // Si no deseas validar, puedes omitir esta línea.

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos[0]) || empty($datos[0])) {
        throw new Exception("Código de proveedor no recibido.");
    }

    $codigoProveedor = trim($datos[0]);

    $sql = "
        SELECT 
            p.id,
            p.codigo_producto,
            p.nombre,
            p.afecto_igv,
            p.porcentaje_igv,
            p.isc,
            p.fise,
            p.peso,
            p.capacidad,
            p.pprecio_menor,
            p.pprecio_mayor,
            p.pprecio_dist,
            p.precmenor_und,
            p.precmenor_fra,
            p.precmayor_und,
            p.precmayor_fra,
            p.precdist_und,
            p.precdist_fra,
            um.abrev,
            um.abrev_universal,
            pp.flete,
            pp.estiba,
            pp.descuento
        FROM productos p 
        INNER JOIN productos_proveedor pp ON pp.producto_id = p.id
        LEFT JOIN unidadmedida um ON um.id = p.unidad_id
        WHERE pp.codigo_proveedor = :codigoProveedor
        LIMIT 1
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(":codigoProveedor", $codigoProveedor, PDO::PARAM_STR);
    $stmt->execute();

    $producto = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$producto) {
        echo json_encode([]); // No encontrado
    } else {
        echo json_encode([$producto], JSON_UNESCAPED_UNICODE);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
} finally {
    $stmt = null;
    $conn = null;
}
?>
