<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 3) {
        throw new Exception("Datos incompletos");
    }

    $operacion = $datos[0];
    $almacen_id = $datos[1];
    $producto_id = $datos[2];

    $sql = "SELECT * FROM kardex WHERE operacion = :operacion AND almacen_id = :almacen_id AND producto_id = :producto_id";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':operacion', $operacion, PDO::PARAM_STR);
    $stmt->bindParam(':almacen_id', $almacen_id, PDO::PARAM_INT);
    $stmt->bindParam(':producto_id', $producto_id, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    error_response("Error en base de datos: " . $e->getMessage());
} catch (Exception $e) {
    error_response("Error: " . $e->getMessage());
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
