<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Validar token de sesión
$usuarioId = TokenValidator::validar($conn);

try {
    $body = file_get_contents("php://input");
    $datos = json_decode($body, true);

    if (!isset($datos[0]) || !is_numeric($datos[0])) {
        throw new Exception("El parámetro operacion_id es obligatorio y debe ser numérico.");
    }

    if (!isset($datos[1]) || !is_numeric($datos[1])) {
        throw new Exception("El parámetro empresa_id es obligatorio y debe ser numérico.");
    }

    $operacion_id = (int)$datos[0];
    $empresa_id   = (int)$datos[1];

    // Ejecutar función para llenar la tabla temporal
    $conn->beginTransaction();
    $sql_funcion = "SELECT insertar_temp_cuentas_por_operacion(:operacion_id, :empresa_id)";
    $stmt = $conn->prepare($sql_funcion);
    $stmt->bindValue(':operacion_id', $operacion_id, PDO::PARAM_INT);
    $stmt->bindValue(':empresa_id', $empresa_id, PDO::PARAM_INT);
    $stmt->execute();

    // Leer resultados de la tabla temporal
    $sql_select = "SELECT id, nombre FROM temp_cuentas ORDER BY nombre";
    $stmt2 = $conn->prepare($sql_select);
    $stmt2->execute();
    $rows = $stmt2->fetchAll(PDO::FETCH_ASSOC);

    $conn->commit();
    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    $conn->rollBack();
    http_response_code(500);
    echo json_encode(['error' => "❌ Servidor: " . $e->getMessage()], JSON_UNESCAPED_UNICODE);
} finally {
    $stmt = null;
    $stmt2 = null;
    $conn = null;
}
?>