<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

try {
    // Preparar la llamada al procedimiento almacenado en PostgreSQL
    $sql = "SELECT actualizar_stock(:param1)"; // ✅ nombre corregido
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':param1', $datos[0], PDO::PARAM_INT);
    $stmt->execute();

    // Obtener el resultado de la función
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $nRegistros = $result['actualizar_stock']; // ✅ clave exacta igual al nombre de la función

    if ($nRegistros > 0) {
        $resultado = [
            "ESTADO" => "1",
            "REGISTROS" => $nRegistros,
            "MENSAJE" => "LA INFORMACION SE ACTUALIZO CORRECTAMENTE"
        ];
    } else {
        $resultado = [
            "ESTADO" => "0",
            "REGISTROS" => "0",
            "MENSAJE" => "NO SE ACTUALIZÓ NINGÚN REGISTRO"
        ];
    }
} catch (Exception $e) {
    $resultado = [
        "MENSAJE" => "ERROR: " . $e->getMessage(),
        "ESTADO" => "0",
        "ID" => "0"
    ];
}

$conn = null; // Cerrar la conexión a PostgreSQL

header("Content-Type: application/json; charset=UTF-8");
echo json_encode($resultado, JSON_PRETTY_PRINT);
?>